// EventCountDlg.cpp : implementation file
//

#include "stdafx.h"
#include "EventCount.h"
#include "EventCountDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEventCountDlg dialog

CEventCountDlg::CEventCountDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEventCountDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEventCountDlg)
	m_counts = _T("");
	m_errString = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CEventCountDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEventCountDlg)
	DDX_Control(pDX, IDC_READ, m_read);
	DDX_Control(pDX, IDC_STOP, m_stop);
	DDX_Control(pDX, IDC_START, m_start);
	DDX_Text(pDX, IDC_COUNTS, m_counts);
	DDX_Text(pDX, IDC_ERROR_STRING, m_errString);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEventCountDlg, CDialog)
	//{{AFX_MSG_MAP(CEventCountDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_READ, OnRead)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEventCountDlg message handlers

BOOL CEventCountDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CEventCountDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEventCountDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CEventCountDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEventCountDlg::OnOpen() 
{
	// TODO: Add your control notification handler code here
/*	

  This program was tested in Windows 2000 SP1, 3140-850A02 DriverLINX
  Microsoft VC++ 6.0 Standard Edition

  Apply TTL signal to be counted at pin 2 of STP-3140; pin 67 of STP-68

*/

	   // Open the driver and Initialize the hardware
m_pSR=NULL;
m_driverInstance=NULL;
// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application

DriverLINX(m_pSR);    //Execute the initialize service
showMessage(m_pSR);   //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_start.EnableWindow(TRUE);  // enable the Start button
}

// set focus back to our dialog
CWnd::SetActiveWindow();		
}

void CEventCountDlg::OnStart() 
{
	
// set up a task to use CT channel 0 for event counting
m_pSR->operation=START;  // start operation
m_pSR->subsystem=CT;     // using CT subsystem
m_pSR->mode=POLLED;      // no timing info required.....POLLED mode
m_pSR->start.typeEvent=COMMAND;   // start when we call DriverLINX function
m_pSR->timing.typeEvent=RATEEVENT;  // speed of the task will be specified
m_pSR->stop.typeEvent=NULLEVENT;  // no stop type required
m_pSR->timing.u.rateEvent.channel=0;   // use channel 0 of CT subsystem
m_pSR->timing.u.rateEvent.mode=COUNT;  // 16-bit Counting vs. COUNT32 or COUNT64
m_pSR->timing.u.rateEvent.pulses=0;     // 0 = roll over and keep going
//m_pSR->timing.u.rateEvent.pulses=0;   // 1 =  roll over and stop    
m_pSR->timing.u.rateEvent.clock=EXTERNAL;  // feed your signal into CT0
//m_pSR->timing.u.rateEvent.onCount=0;  // not used
m_pSR->timing.u.rateEvent.gate=NOCONNECT;  // gating not used in this example
DriverLINX(m_pSR);
showMessage(m_pSR);
// control our buttons......
m_start.EnableWindow(FALSE);
m_read.EnableWindow(TRUE);	
}

void CEventCountDlg::OnRead() 
{
	// to a STATUS operation to read the count value
m_pSR->operation=STATUS;
m_pSR->status.typeStatus=TIMERSTATUS;
DriverLINX(m_pSR);
showMessage(m_pSR);
m_counts.Format("%d",m_pSR->status.u.timerStatus.count);
UpdateData(FALSE);
// control our buttons...
m_stop.EnableWindow(TRUE);	
}

void CEventCountDlg::OnStop() 
{
	// stop the Event Counting task
/*
  if we do a STOP operation on a task that does not exist, an error will result.
  this app does not do any error checking for this condition.
*/
m_pSR->operation=STOP;	
DriverLINX(m_pSR);
//  would be "active task not found" error if no active task existed
//  But it does not kill us.
m_stop.EnableWindow(FALSE);  // disable the Stop button
m_start.EnableWindow(TRUE);  // enable the Start button	
m_read.EnableWindow(FALSE);  // disable the read button
}

void CEventCountDlg::showMessage(DL_ServiceRequest *SR)
{
	//SR->operation=MESSAGEBOX;
	//DriverLINX(SR);

// the code below could be used instead of the messagebox operation above

DWORD size=50;
int errNumber;
char errString[100];   // used to export error string
errNumber = getErrCode(SR->result);
// errNumber corresponds to DriverLINX documentation
ReturnMessageString(SR->hWnd,SR->result,errString,size);
// errString corresponds to DriverLINX documentation
m_errString.Format("%s",errString);
UpdateData(FALSE);  // update the dialog
return;
}


void CEventCountDlg::OnClose() 
{
	// When the Dialog is closed (WM_CLOSE) close down DriverLINX
// code to clean up after DriverLINX
if (m_driverInstance != NULL)
{
   CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
   m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR != NULL)
{

   delete(m_pSR); //de-allocate the memory used by the service request
   m_pSR=NULL;
}	
	CDialog::OnClose();
}
